/*
 * Decompiled with CFR 0.152.
 */
package collision.packets;

import collision.handlers.ModConfig;
import collisiondamage.core.CollisionDamage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCollisionS
implements IMessage {
    private double accel;

    public double getAccel() {
        return this.accel;
    }

    public PacketCollisionS() {
        this.accel = 0.0;
    }

    public PacketCollisionS(double accel) {
        this.accel = accel;
    }

    public void fromBytes(ByteBuf buf) {
        this.accel = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.accel);
    }

    public static class CollisionMessageHandler
    implements IMessageHandler<PacketCollisionS, IMessage> {
        public IMessage onMessage(PacketCollisionS message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayer player = CollisionDamage.proxy.getPlayer(ctx);
                if (player == null) {
                    return null;
                }
                double accel = message.getAccel();
                IThreadListener thread = CollisionDamage.proxy.getListener(ctx);
                thread.func_152344_a(() -> {
                    if (accel > ModConfig.server.accelerationThreshold) {
                        float damageValue = (float)Math.round((accel - ModConfig.server.accelerationThreshold) * 4.0 * ModConfig.server.damageMultiplier) / 4.0f;
                        player.func_184185_a(damageValue > 4.0f ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE, 1.0f, 1.0f);
                        player.func_70097_a(ModConfig.server.damageTypeWall ? DamageSource.field_188406_j : DamageSource.field_76379_h, damageValue);
                    }
                });
            }
            return null;
        }
    }
}

